package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 结算周期
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum Cycle {

    _0("0", "月"),
    _1("1", "季度"),
    _2("2", "半年"),
    _3("3", "年"),
    _4("4", "日");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Cycle(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Cycle fromCode(String code) {
        return Stream.of(Cycle.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
