package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 维度说明
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum DimensionEnum {

    ORDER("order", "订单"),
    TAX("tax", "税号"),
    INVOICE("invoice", "发票"),
    PAY_WATER("payWater", "回款流水");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DimensionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DimensionEnum fromCode(String code) {
        return Stream.of(DimensionEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
