package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 财务预算科目明细类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum FinancifalBudgetType {

    _1("1", "项目管理人工成本"),
    _2("2", "项目管理差旅预算"),
    _3("3", "项目管理客情预算"),
    _4("4", "交付实施人工成本"),
    _5("5", "交付实施差旅预算"),
    _6("6", "运维预算"),
    _7("7", "超级/高级支持服务预算"),
    _8("8", "交付实施客情预算");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FinancifalBudgetType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FinancifalBudgetType fromCode(String code) {
        return Stream.of(FinancifalBudgetType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
