package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 费控佳审批状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum FjkApproveStatusEnum {

    PASS("pass", "审批通过"),
    IN_APPROVE("inApprove", "审批中"),
    RETURN_DIRECT("returnDirect", "退回直送"),
    RETURN_RESET_APPROVE("returnResetApprove", "退回重审"),
    CLOSE("close", "关闭");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FjkApproveStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FjkApproveStatusEnum fromCode(String code) {
        return Stream.of(FjkApproveStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
