package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 滴滴公司主体与部门映射类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum LegalEntityBudgetCenterType {

    _1("1", "公司主体"),
    _2("2", "公司部门");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    LegalEntityBudgetCenterType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LegalEntityBudgetCenterType fromCode(String code) {
        return Stream.of(LegalEntityBudgetCenterType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
