package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 订单开票状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum OrderInvoiceStatusEnum {

    _0("0", "未开票"),
    _1("1", "全部开票"),
    _2("2", "部分开票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrderInvoiceStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderInvoiceStatusEnum fromCode(String code) {
        return Stream.of(OrderInvoiceStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
