package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 订单类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum OrderType {

    ONE_TIME("oneTime", "一次性"),
    CONTINUITY("continuity", "持续性");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderType fromCode(String code) {
        return Stream.of(OrderType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
