package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 阶段
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum Phase {

    _1("1", "调研"),
    _2("2", "方案设计");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Phase(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Phase fromCode(String code) {
        return Stream.of(Phase.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
