package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 产品功能描述
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum ProductFuctionDesc {

    _0("0", "无"),
    _1("1", "直连"),
    _2("2", "抽取"),
    _3("3", "验真"),
    _4("4", "认证"),
    _5("5", "识别"),
    _6("6", "直连+认证");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProductFuctionDesc(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductFuctionDesc fromCode(String code) {
        return Stream.of(ProductFuctionDesc.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
