package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 产品收入类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum ProductIncomeType {

    _1("1", "项目验收订单收入"),
    _2("2", "质保金收入"),
    _3("3", "持续性非Saas收入"),
    _4("4", "持续性收入"),
    _5("5", "加量包收入"),
    _6("6", "按次收入"),
    _7("7", "冲减收入"),
    _8("8", "一次性待确认收入");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProductIncomeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductIncomeType fromCode(String code) {
        return Stream.of(ProductIncomeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
