package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 性质
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum PropertyEnum {

    _0("0", "一次性"),
    _1("1", "持续性"),
    _2("2", "持续性(非SAAS)");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PropertyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PropertyEnum fromCode(String code) {
        return Stream.of(PropertyEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
