package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 对账状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum ReconcilationStatus {

    _0("0", "未对账"),
    _1("1", "对账中"),
    _2("2", "已对账"),
    _3("3", "已申诉"),
    _4("4", "申诉已处理");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReconcilationStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReconcilationStatus fromCode(String code) {
        return Stream.of(ReconcilationStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
