package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 对帐状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum ReconciliationStatusEnum {

    _0("0", "未对账"),
    _1("1", "对账中"),
    _2("2", "已申诉"),
    _3("3", "申诉已处理"),
    _4("4", "已对账"),
    __1("-1", "已生成未审批");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReconciliationStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReconciliationStatusEnum fromCode(String code) {
        return Stream.of(ReconciliationStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
