package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 小B合同状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum SmallContractStatus {

    _0("0", "未签署"),
    _1("1", "线上签署"),
    _2("2", "线下签署");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SmallContractStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SmallContractStatus fromCode(String code) {
        return Stream.of(SmallContractStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
