package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 小B支付方式
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum SmallPaymentType {

    OFFLINE("OFFLINE", "线下支付"),
    ALIPAY("ALIPAY", "支付宝支付"),
    BAOFU("BAOFU", "宝付"),
    BAOFU_WECHAT("BAOFU_WECHAT", "宝付-微信支付"),
    BAOFU_ALIPAY("BAOFU_ALIPAY", "宝付-支付宝支付"),
    BAOFU_WECHAT_MP("BAOFU_WECHAT_MP", "宝付-微信公众号支付");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SmallPaymentType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SmallPaymentType fromCode(String code) {
        return Stream.of(SmallPaymentType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
