package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 台账状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum StandingBookStatusEnum {

    _1("1", "无需确认"),
    _2("2", "待确认"),
    _3("3", "已确认"),
    _4("4", "已退回");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StandingBookStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StandingBookStatusEnum fromCode(String code) {
        return Stream.of(StandingBookStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
