package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 补充协议枚举类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum SupplementaryAgreementTypesEnum {

    _1("1", "商务&法务条文"),
    _2("2", "新增产品&服务"),
    _3("3", "新增税号"),
    _4("4", "计费条件"),
    _5("5", "结算条件");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SupplementaryAgreementTypesEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SupplementaryAgreementTypesEnum fromCode(String code) {
        return Stream.of(SupplementaryAgreementTypesEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
