package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 成本类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
public enum Type {

    _0("0", "产品线"),
    _1("1", "中台基础服务"),
    _2("2", "项目"),
    _3("3", "B类不分摊产品");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Type(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Type fromCode(String code) {
        return Stream.of(Type.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
