package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * financial_purchase_bill
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialPurchaseBill extends FinancialApplyBasicBill {

  /**
   * 采购用途
   */
  private String procurementPurposes;
  /**
   * 采购类别编码
   */
  private String procurementTypeCode;
  /**
   * 采购类别名称
   */
  private String procurementTypeName;
  /**
   * 采购目的编码
   */
  private String procurementPurposesCode;
  /**
   * 采购目的名称
   */
  private String procurementPurposesName;
  /**
   * 项目文本
   */
  private String projectTxt;
  /**
   * 采购事由
   */
  private String procurementCause;
  /**
   * 项目档案编码
   */
  private String projectArchivesCode;
  /**
   * 项目档案名称
   */
  private String projectArchivesName;
  /**
   * 一级部门
   */
  private String oneDepr;
  /**
   * 所属公司编码
   */
  private String companyCode;
  /**
   * 所属公司名称
   */
  private String companyName;
  /**
   * 采购方式编码
   */
  private String procurementWayCode;
  /**
   * 采购方式名称
   */
  private String procurementWayName;
  /**
   * 项目所属区域名称
   */
  private String projectAreaName;
  /**
   * 是否完成钉钉采购申请
   */
  private String ifDingDingapply;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("procurementPurposes", procurementPurposes);
      map.put("procurementTypeCode", procurementTypeCode);
      map.put("procurementTypeName", procurementTypeName);
      map.put("procurementPurposesCode", procurementPurposesCode);
      map.put("procurementPurposesName", procurementPurposesName);
      map.put("projectTxt", projectTxt);
      map.put("procurementCause", procurementCause);
      map.put("projectArchivesCode", projectArchivesCode);
      map.put("projectArchivesName", projectArchivesName);
      map.put("oneDepr", oneDepr);
      map.put("companyCode", companyCode);
      map.put("companyName", companyName);
      map.put("procurementWayCode", procurementWayCode);
      map.put("procurementWayName", procurementWayName);
      map.put("projectAreaName", projectAreaName);
      map.put("ifDingDingapply", ifDingDingapply);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static FinancialPurchaseBill fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialPurchaseBill entity = new FinancialPurchaseBill();

    entity.setParentByOQSMap(map);
    if(map.containsKey("procurementPurposes")) {
      Object obj = map.get("procurementPurposes");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementPurposes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeCode")) {
      Object obj = map.get("procurementTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeName")) {
      Object obj = map.get("procurementTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementPurposesCode")) {
      Object obj = map.get("procurementPurposesCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementPurposesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementPurposesName")) {
      Object obj = map.get("procurementPurposesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementPurposesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectTxt")) {
      Object obj = map.get("projectTxt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectTxt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementCause")) {
      Object obj = map.get("procurementCause");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesCode")) {
      Object obj = map.get("projectArchivesCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectArchivesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesName")) {
      Object obj = map.get("projectArchivesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectArchivesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oneDepr")) {
      Object obj = map.get("oneDepr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOneDepr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayCode")) {
      Object obj = map.get("procurementWayCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayName")) {
      Object obj = map.get("procurementWayName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectAreaName")) {
      Object obj = map.get("projectAreaName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectAreaName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ifDingDingapply")) {
      Object obj = map.get("ifDingDingapply");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIfDingDingapply((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("procurementPurposes")) {
      Object obj = map.get("procurementPurposes");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementPurposes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeCode")) {
      Object obj = map.get("procurementTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeName")) {
      Object obj = map.get("procurementTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementPurposesCode")) {
      Object obj = map.get("procurementPurposesCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementPurposesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementPurposesName")) {
      Object obj = map.get("procurementPurposesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementPurposesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectTxt")) {
      Object obj = map.get("projectTxt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectTxt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementCause")) {
      Object obj = map.get("procurementCause");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesCode")) {
      Object obj = map.get("projectArchivesCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectArchivesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesName")) {
      Object obj = map.get("projectArchivesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectArchivesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oneDepr")) {
      Object obj = map.get("oneDepr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOneDepr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayCode")) {
      Object obj = map.get("procurementWayCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayName")) {
      Object obj = map.get("procurementWayName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectAreaName")) {
      Object obj = map.get("projectAreaName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectAreaName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ifDingDingapply")) {
      Object obj = map.get("ifDingDingapply");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIfDingDingapply((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
