package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * financial_purchase_contract_bill
 * </p>
 *
 * @author ultraman
 * @since 2023-07-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialPurchaseContractBill extends FinancialApplyBasicBill {

  /**
   * 采购事项单据单号
   */
  private String procurementDocumentsNo;
  /**
   * 采购事项单据标题
   */
  private String procurementDocumentsTitle;
  /**
   * 合同摘要
   */
  private String contractParticulars;
  /**
   * 合同总金额
   */
  private String contractAmount;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 一式几份
   */
  private String fewCopies;
  /**
   * 主合同编号
   */
  private String masterContractCode;
  /**
   * 标题
   */
  private String title;
  /**
   * 邮寄信息
   */
  private String mailingAddress;
  /**
   * 供应商编码
   */
  private String supplierCode;
  /**
   * 供应商名称
   */
  private String supplierName;
  /**
   * 采购方式编码
   */
  private String procurementWayCode;
  /**
   * 采购方式名称
   */
  private String procurementWayName;
  /**
   * 取件方式编码
   */
  private String deliveryWayCode;
  /**
   * 取件方式名称
   */
  private String deliveryWayName;
  /**
   * 验收方式编码
   */
  private String checkWayCode;
  /**
   * 验收方式名称
   */
  private String checkWayName;
  /**
   * 文件类型编码
   */
  private String fileTypeCode;
  /**
   * 文件类型名称
   */
  private String fileTypeName;
  /**
   * 印鉴类型编码
   */
  private String signatureTypeCode;
  /**
   * 印鉴类型名称
   */
  private String signatureTypeName;
  /**
   * 采购合同台账编码
   */
  private String procurementStandingCode;
  /**
   * 采购合同台账名称
   */
  private String procurementStandingName;
  /**
   * 采购单号
   */
  private String procurementNo;
  /**
   * 项目文本
   */
  private String projectTxt;
  /**
   * 签约主体
   */
  private String contractParty;
  /**
   * 合同签约主体编码
   */
  private String contractPartyCode;
  /**
   * 合同签约主体名称
   */
  private String contractPartyName;
  /**
   * 项目档案编码
   */
  private String projectArchivesCode;
  /**
   * 项目档案名称
   */
  private String projectArchivesName;
  /**
   * 采购申请金额
   */
  private String procurementapplyAmount;
  /**
   * 合同名称
   */
  private String contractName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("procurementDocumentsNo", procurementDocumentsNo);
      map.put("procurementDocumentsTitle", procurementDocumentsTitle);
      map.put("contractParticulars", contractParticulars);
      map.put("contractAmount", contractAmount);
      map.put("contractNo", contractNo);
      map.put("fewCopies", fewCopies);
      map.put("masterContractCode", masterContractCode);
      map.put("title", title);
      map.put("mailingAddress", mailingAddress);
      map.put("supplierCode", supplierCode);
      map.put("supplierName", supplierName);
      map.put("procurementWayCode", procurementWayCode);
      map.put("procurementWayName", procurementWayName);
      map.put("deliveryWayCode", deliveryWayCode);
      map.put("deliveryWayName", deliveryWayName);
      map.put("checkWayCode", checkWayCode);
      map.put("checkWayName", checkWayName);
      map.put("fileTypeCode", fileTypeCode);
      map.put("fileTypeName", fileTypeName);
      map.put("signatureTypeCode", signatureTypeCode);
      map.put("signatureTypeName", signatureTypeName);
      map.put("procurementStandingCode", procurementStandingCode);
      map.put("procurementStandingName", procurementStandingName);
      map.put("procurementNo", procurementNo);
      map.put("projectTxt", projectTxt);
      map.put("contractParty", contractParty);
      map.put("contractPartyCode", contractPartyCode);
      map.put("contractPartyName", contractPartyName);
      map.put("projectArchivesCode", projectArchivesCode);
      map.put("projectArchivesName", projectArchivesName);
      map.put("procurementapplyAmount", procurementapplyAmount);
      map.put("contractName", contractName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static FinancialPurchaseContractBill fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialPurchaseContractBill entity = new FinancialPurchaseContractBill();

    entity.setParentByOQSMap(map);
    if(map.containsKey("procurementDocumentsNo")) {
      Object obj = map.get("procurementDocumentsNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementDocumentsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementDocumentsTitle")) {
      Object obj = map.get("procurementDocumentsTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementDocumentsTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractParticulars")) {
      Object obj = map.get("contractParticulars");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractParticulars((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractAmount")) {
      Object obj = map.get("contractAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fewCopies")) {
      Object obj = map.get("fewCopies");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFewCopies((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("masterContractCode")) {
      Object obj = map.get("masterContractCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMasterContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("title")) {
      Object obj = map.get("title");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mailingAddress")) {
      Object obj = map.get("mailingAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMailingAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayCode")) {
      Object obj = map.get("procurementWayCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayName")) {
      Object obj = map.get("procurementWayName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryWayCode")) {
      Object obj = map.get("deliveryWayCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryWayName")) {
      Object obj = map.get("deliveryWayName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkWayCode")) {
      Object obj = map.get("checkWayCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkWayName")) {
      Object obj = map.get("checkWayName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileTypeCode")) {
      Object obj = map.get("fileTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFileTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileTypeName")) {
      Object obj = map.get("fileTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFileTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signatureTypeCode")) {
      Object obj = map.get("signatureTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSignatureTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signatureTypeName")) {
      Object obj = map.get("signatureTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSignatureTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementStandingCode")) {
      Object obj = map.get("procurementStandingCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementStandingCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementStandingName")) {
      Object obj = map.get("procurementStandingName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementStandingName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementNo")) {
      Object obj = map.get("procurementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectTxt")) {
      Object obj = map.get("projectTxt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectTxt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractParty")) {
      Object obj = map.get("contractParty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractParty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractPartyCode")) {
      Object obj = map.get("contractPartyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractPartyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractPartyName")) {
      Object obj = map.get("contractPartyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractPartyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesCode")) {
      Object obj = map.get("projectArchivesCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectArchivesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesName")) {
      Object obj = map.get("projectArchivesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectArchivesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementapplyAmount")) {
      Object obj = map.get("procurementapplyAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementapplyAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractName")) {
      Object obj = map.get("contractName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("procurementDocumentsNo")) {
      Object obj = map.get("procurementDocumentsNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementDocumentsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementDocumentsTitle")) {
      Object obj = map.get("procurementDocumentsTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementDocumentsTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractParticulars")) {
      Object obj = map.get("contractParticulars");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractParticulars((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractAmount")) {
      Object obj = map.get("contractAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fewCopies")) {
      Object obj = map.get("fewCopies");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFewCopies((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("masterContractCode")) {
      Object obj = map.get("masterContractCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMasterContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("title")) {
      Object obj = map.get("title");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mailingAddress")) {
      Object obj = map.get("mailingAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMailingAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayCode")) {
      Object obj = map.get("procurementWayCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayName")) {
      Object obj = map.get("procurementWayName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryWayCode")) {
      Object obj = map.get("deliveryWayCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeliveryWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryWayName")) {
      Object obj = map.get("deliveryWayName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeliveryWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkWayCode")) {
      Object obj = map.get("checkWayCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkWayName")) {
      Object obj = map.get("checkWayName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileTypeCode")) {
      Object obj = map.get("fileTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFileTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileTypeName")) {
      Object obj = map.get("fileTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFileTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signatureTypeCode")) {
      Object obj = map.get("signatureTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSignatureTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signatureTypeName")) {
      Object obj = map.get("signatureTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSignatureTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementStandingCode")) {
      Object obj = map.get("procurementStandingCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementStandingCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementStandingName")) {
      Object obj = map.get("procurementStandingName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementStandingName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementNo")) {
      Object obj = map.get("procurementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectTxt")) {
      Object obj = map.get("projectTxt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectTxt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractParty")) {
      Object obj = map.get("contractParty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractParty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractPartyCode")) {
      Object obj = map.get("contractPartyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractPartyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractPartyName")) {
      Object obj = map.get("contractPartyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractPartyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesCode")) {
      Object obj = map.get("projectArchivesCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectArchivesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesName")) {
      Object obj = map.get("projectArchivesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectArchivesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementapplyAmount")) {
      Object obj = map.get("procurementapplyAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementapplyAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractName")) {
      Object obj = map.get("contractName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
