package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * adjust_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum AdjustStatusEnum {

    _0("0", "正常"),
    _1("1", "调整");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AdjustStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AdjustStatusEnum fromCode(String code) {
        return Stream.of(AdjustStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
