package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_type_second_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum BillTypeSecondEnum {

    _0("0", "税号"),
    _1("1", "业务"),
    _100("100", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillTypeSecondEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillTypeSecondEnum fromCode(String code) {
        return Stream.of(BillTypeSecondEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
