package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bind_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum BindTypeEnum {

    BIND("BIND", "绑定"),
    UNBIND("UNBIND", "解绑");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BindTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BindTypeEnum fromCode(String code) {
        return Stream.of(BindTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
