package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bs_employ_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum BsEmployTypeEnum {

    _0("0", "内部员工"),
    _2("2", "实习生"),
    _1("1", " 外部人员");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BsEmployTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BsEmployTypeEnum fromCode(String code) {
        return Stream.of(BsEmployTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
