package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cd_sign_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum CdSignEnum {

    _0("0", "收入"),
    _1("1", "支出");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CdSignEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CdSignEnum fromCode(String code) {
        return Stream.of(CdSignEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
