package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * charge_biz_dimension_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum ChargeBizDimensionEnum {

    CERTIFICATION_TIMES("CERTIFICATION_TIMES", "认证次数"),
    CERTIFICATE_INVOICE_PIECES("CERTIFICATE_INVOICE_PIECES", "认证发票张数"),
    VERIFY_TIMES("VERIFY_TIMES", "验真次数"),
    VERIFY_INVOICE_PIECES("VERIFY_INVOICE_PIECES", "验真发票张数"),
    MAKE_OUT_INVOICE_PIECES("MAKE_OUT_INVOICE_PIECES", "开票张数"),
    OCR_TIMES("OCR_TIMES", "识别次数"),
    FILE("FILE", "文件服务");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeBizDimensionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeBizDimensionEnum fromCode(String code) {
        return Stream.of(ChargeBizDimensionEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
