package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * charge_code_relation_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum ChargeCodeRelationEnum {

    YKB("YKB", "易快报");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeCodeRelationEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeRelationEnum fromCode(String code) {
        return Stream.of(ChargeCodeRelationEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
