package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * charge_code_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum ChargeCodeTypeEnum {

    SA("SA", "客户"),
    PS("PS", "机会"),
    DL("DL", "交付"),
    CSM("CSM", "CSM"),
    BU("BU", "BU"),
    IDLE("IDLE", "空闲"),
    SMB("SMB", "小B运营"),
    SS("SS", "销售"),
    TR("TR", "培训"),
    BG("BG", "数据增值"),
    CO("CO", "董办"),
    EB("EB", "生态业务筹备组"),
    FA("FA", "财务"),
    GM("GM", "综合管理"),
    GS("GS", "光是"),
    HL("HL", "休假"),
    HR("HR", "人事部"),
    JF("JF", "交付部"),
    KF("KF", "客户服务部"),
    OM("OM", "运维"),
    PD("PD", "产品"),
    PE("PE", "商联"),
    RD("RD", "研发"),
    SL("SL", "解决方案"),
    SO("SO", "战略运营中心"),
    SQ("SQ", "售前"),
    IS("IS", "系统服务部"),
    ZJ("ZJ", "专家"),
    DCSM("DCSM", "客户成功部"),
    LG("LG", "法务"),
    SP("SP", "战略专项"),
    PO("PO", "总裁办");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeCodeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeTypeEnum fromCode(String code) {
        return Stream.of(ChargeCodeTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
