package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * charge_rules
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum ChargeRules {

    _1("1", "按日计费"),
    _2("2", "按价计费"),
    _3("3", "按月计费");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeRules(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeRules fromCode(String code) {
        return Stream.of(ChargeRules.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
