package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * current_status
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum CurrentStatus {

    _0("0", "已对账"),
    _1("1", "已开票"),
    _2("2", "已回款"),
    _3("3", "已核销");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CurrentStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CurrentStatus fromCode(String code) {
        return Stream.of(CurrentStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
