package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_source
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum DataSource {

    _1("1", "PMS"),
    _2("2", "费控佳"),
    _3("3", "中台分摊");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataSource fromCode(String code) {
        return Stream.of(DataSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
