package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * device_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum DeviceTypeEnum {

    CORE_BOARD("CORE_BOARD", "核心板"),
    TAX_DISK("TAX_DISK", "税盘"),
    UKEY("UKEY", "Ukey"),
    SOFT_CERTIFICATE("SOFT_CERTIFICATE", "软证书"),
    TAX_SERVER("TAX_SERVER", "服务器");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DeviceTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DeviceTypeEnum fromCode(String code) {
        return Stream.of(DeviceTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
