package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * financifal_budget_type
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum FinancifalBudgetType {

    _1("1", "项目管理人工成本"),
    _2("2", "项目管理差旅预算"),
    _3("3", "项目管理客情预算"),
    _4("4", "交付实施人工成本"),
    _5("5", "交付实施差旅预算"),
    _6("6", "运维预算"),
    _7("7", "超级/高级支持服务预算"),
    _8("8", "交付实施客情预算"),
    D001("D001", "部门-差旅费"),
    D002("D002", "部门-业务招待费"),
    D003("D003", "部门-行政办公费"),
    D004("D004", "部门-房租物业"),
    D005("D005", "部门-福利费"),
    D006("D006", "部门-团建活动费"),
    D007("D007", "部门-计算机及相关办公设备"),
    D008("D008", "部门-培训会议费"),
    D009("D009", "部门-云资通道及托管服务"),
    D010("D010", "部门-市场服务费"),
    D011("D011", "部门-综合服务费"),
    D012("D012", "部门-其他产品服务费"),
    D013("D013", "部门-差旅相关平台充值");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FinancifalBudgetType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FinancifalBudgetType fromCode(String code) {
        return Stream.of(FinancifalBudgetType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
