package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * fkj_bill_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum FkjBillTypeEnum {

    PUBLIC_BILL("publicBill", "对公报销单"),
    PUBLIC_PRE_BILL("publicPreBill", "对公预付款申请单"),
    NORMAL_BILL("normalBill", "日常报销单"),
    PUBLIC_CTRIP_BILL("publicCtripBill", "携程对公报销单"),
    OWNER_BILL("ownerBill", "个人借款申请单"),
    TRAVEL_BILL("travelBill", "差旅申请单"),
    BU_THING_PRE_BILL("buThingPreBill", "业务招待事前申请单"),
    BUYER_BILL("buyerBill", "采购申请单"),
    CONTRACT("contract", "通用合同");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FkjBillTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FkjBillTypeEnum fromCode(String code) {
        return Stream.of(FkjBillTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
