package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * fkj_pay_way_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum FkjPayWayEnum {

    BANK("bank", "银行转账"),
    PRE_PAY("prePay", "结转预付款");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FkjPayWayEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FkjPayWayEnum fromCode(String code) {
        return Stream.of(FkjPayWayEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
