package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * input_way
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum InputWay {

    _0("0", "人工手动录入"),
    _1("1", "后台计算");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InputWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InputWay fromCode(String code) {
        return Stream.of(InputWay.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
