package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * module
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum Module {

    _0("0", "无"),
    _1("1", "进项"),
    _2("2", "销项"),
    _3("3", "供应商");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Module(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Module fromCode(String code) {
        return Stream.of(Module.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
