package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pay_type
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum PayType {

    NEW_BUY("NEW_BUY", "新购"),
    RECHARGE("RECHARGE", "续费"),
    BACK("BACK", "补缴"),
    UPGRADE("UPGRADE", "升级");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PayType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PayType fromCode(String code) {
        return Stream.of(PayType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
