package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * process_type
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum ProcessType {

    FORWARD_FLOW("forwardFlow", "正向流程"),
    REVERSE_PROCESS("reverseProcess", "逆向流程"),
    RETURN_MONEY_IMPORT("returnMoneyImport", "回款流水导入");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProcessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessType fromCode(String code) {
        return Stream.of(ProcessType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
