package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * product_phase
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum ProductPhase {

    _1("1", "产品设计"),
    _2("2", "产品开发"),
    _3("3", "产品运维");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProductPhase(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductPhase fromCode(String code) {
        return Stream.of(ProductPhase.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
