package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * product_status
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum ProductStatus {

    _1("1", "有效"),
    _2("2", "无效");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProductStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductStatus fromCode(String code) {
        return Stream.of(ProductStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
