package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * reception_status
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum ReceptionStatus {

    RECEPTED("recepted", "已验收"),
    NOT_RECEPTED("notRecepted", "未验收");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReceptionStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceptionStatus fromCode(String code) {
        return Stream.of(ReceptionStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
