package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * record_type
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum RecordType {

    _0("0", "新增合同"),
    _1("1", "更新合同"),
    _2("2", "新增计费流水"),
    _3("3", "新增订单"),
    _4("4", "更新订单"),
    _5("5", "新增结算对账明细"),
    _6("6", "新增结算对账单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RecordType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecordType fromCode(String code) {
        return Stream.of(RecordType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
