package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * service_open_flag
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum ServiceOpenFlag {

    FIRST_USE("FIRST_USE", "首次使用"),
    SIGN_CONTRACT("SIGN_CONTRACT", "合同签订"),
    PROJECT_FINISH("PROJECT_FINISH", "项目验收");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ServiceOpenFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ServiceOpenFlag fromCode(String code) {
        return Stream.of(ServiceOpenFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
