package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * small_activate_status
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum SmallActivateStatus {

    _0("0", "未激活"),
    _1("1", "已激活"),
    _2("2", "暂停"),
    _3("3", "重启"),
    _4("4", "已终止");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SmallActivateStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SmallActivateStatus fromCode(String code) {
        return Stream.of(SmallActivateStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
