package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * small_orderservice_close_type
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum SmallOrderserviceCloseType {

    UPGRADE("UPGRADE", "升级"),
    REFUND("REFUND", "退款关闭"),
    UNPAID("UNPAID", "逾期未支付"),
    MANUAL("MANUAL", "用户手工关闭");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SmallOrderserviceCloseType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SmallOrderserviceCloseType fromCode(String code) {
        return Stream.of(SmallOrderserviceCloseType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
