package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * taken_status
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum TakenStatus {

    TAKEN("taken", "已认领"),
    NOT_TAKEN("notTaken", "未认领"),
    NO_NEED("noNeed", "无需认领"),
    PART_TAKEN("partTaken", "部分认领");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TakenStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TakenStatus fromCode(String code) {
        return Stream.of(TakenStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
