package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * whther_or_not
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public enum WhtherOrNot {

    FALSE("false", "否"),
    TRUE("true", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WhtherOrNot(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WhtherOrNot fromCode(String code) {
        return Stream.of(WhtherOrNot.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
