package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * employee_consume_cost
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EmployeeConsumeCost implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 数据来源
   */
  private String source;
  /**
   * 期间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime periodTime;
  /**
   * 制单人编码
   */
  private String tripper;
  /**
   * 制单人名称
   */
  private String tripCode;
  /**
   * 单据模板名称
   */
  private String bilTempleateName;
  /**
   * 单据号
   */
  private String bizNo;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 标题
   */
  private String applyName;
  /**
   * 提交日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyDate;
  /**
   * 支付日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payDate;
  /**
   * 消费事由
   */
  private String consumeReason;
  /**
   * ChargeCode类型
   */
  private String chargeCodeType;
  /**
   * ChargeCode编码
   */
  private String chargeCode;
  /**
   * ChargeCode名称
   */
  private String chargeName;
  /**
   * Owner编码
   */
  private String chargeOwnerCode;
  /**
   * Owner名称
   */
  private String chargeOwnerName;
  /**
   * 费用金额
   */
  private BigDecimal costAmount;
  /**
   * 费用类型
   */
  private String costType;
  /**
   * 费用明细名称
   */
  private String costFullDetail;
  /**
   * 一级费用明细名称
   */
  private String oneCostItem;
  /**
   * 二级费用明细名称
   */
  private String twoCostItem;
  /**
   * 三级费用明细名称
   */
  private String threeCostItem;
  /**
   * 四级费用明细名称
   */
  private String fourCostItem;
  /**
   * 五级费用明细名称
   */
  private String fiveCostItem;
  /**
   * 末级费用明细名称
   */
  private String lastCostItem;
  /**
   * 关联申请编码
   */
  private String refApplyCode;
  /**
   * 关联申请名称
   */
  private String refApplyName;
  /**
   * 供应商名称
   */
  private String supplierName;
  /**
   * 付款类型名称
   */
  private String payTypeName;
  /**
   * 分摊比例/%
   */
  private BigDecimal shareRatio;
  /**
   * 汇总统计所属部门
   */
  private String summaryDepartment;
  /**
   * 是否进入汇总统计
   */
  private String joinSummary;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("source", source);
      map.put("periodTime", BocpGenUtils.toTimestamp(periodTime));
      map.put("tripper", tripper);
      map.put("tripCode", tripCode);
      map.put("bilTempleateName", bilTempleateName);
      map.put("bizNo", bizNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("applyName", applyName);
      map.put("applyDate", BocpGenUtils.toTimestamp(applyDate));
      map.put("payDate", BocpGenUtils.toTimestamp(payDate));
      map.put("consumeReason", consumeReason);
      map.put("chargeCodeType", chargeCodeType);
      map.put("chargeCode", chargeCode);
      map.put("chargeName", chargeName);
      map.put("chargeOwnerCode", chargeOwnerCode);
      map.put("chargeOwnerName", chargeOwnerName);
      map.put("costAmount", costAmount);
      map.put("costType", costType);
      map.put("costFullDetail", costFullDetail);
      map.put("oneCostItem", oneCostItem);
      map.put("twoCostItem", twoCostItem);
      map.put("threeCostItem", threeCostItem);
      map.put("fourCostItem", fourCostItem);
      map.put("fiveCostItem", fiveCostItem);
      map.put("lastCostItem", lastCostItem);
      map.put("refApplyCode", refApplyCode);
      map.put("refApplyName", refApplyName);
      map.put("supplierName", supplierName);
      map.put("payTypeName", payTypeName);
      map.put("shareRatio", shareRatio);
      map.put("summaryDepartment", summaryDepartment);
      map.put("joinSummary", joinSummary);

      return map;
  }

  public static EmployeeConsumeCost fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    EmployeeConsumeCost entity = new EmployeeConsumeCost();

    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("periodTime")) {
      Object obj = map.get("periodTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPeriodTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPeriodTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPeriodTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPeriodTime(null);
      }
    }
    if(map.containsKey("tripper")) {
      Object obj = map.get("tripper");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTripper((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tripCode")) {
      Object obj = map.get("tripCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTripCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bilTempleateName")) {
      Object obj = map.get("bilTempleateName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBilTempleateName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizNo")) {
      Object obj = map.get("bizNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyDate")) {
      Object obj = map.get("applyDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyDate(null);
      }
    }
    if(map.containsKey("payDate")) {
      Object obj = map.get("payDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayDate(null);
      }
    }
    if(map.containsKey("consumeReason")) {
      Object obj = map.get("consumeReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsumeReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCodeType")) {
      Object obj = map.get("chargeCodeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCodeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeName")) {
      Object obj = map.get("chargeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeOwnerCode")) {
      Object obj = map.get("chargeOwnerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeOwnerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeOwnerName")) {
      Object obj = map.get("chargeOwnerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeOwnerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costAmount")) {
      Object obj = map.get("costAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("costType")) {
      Object obj = map.get("costType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costFullDetail")) {
      Object obj = map.get("costFullDetail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostFullDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oneCostItem")) {
      Object obj = map.get("oneCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOneCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("twoCostItem")) {
      Object obj = map.get("twoCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTwoCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("threeCostItem")) {
      Object obj = map.get("threeCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThreeCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fourCostItem")) {
      Object obj = map.get("fourCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFourCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fiveCostItem")) {
      Object obj = map.get("fiveCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFiveCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastCostItem")) {
      Object obj = map.get("lastCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refApplyCode")) {
      Object obj = map.get("refApplyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefApplyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refApplyName")) {
      Object obj = map.get("refApplyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payTypeName")) {
      Object obj = map.get("payTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shareRatio")) {
      Object obj = map.get("shareRatio");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareRatio((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareRatio(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareRatio(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShareRatio(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareRatio(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("summaryDepartment")) {
      Object obj = map.get("summaryDepartment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSummaryDepartment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("joinSummary")) {
      Object obj = map.get("joinSummary");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJoinSummary((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("periodTime")) {
      Object obj = map.get("periodTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPeriodTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPeriodTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPeriodTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPeriodTime(null);
      }
    }
    if(map.containsKey("tripper")) {
      Object obj = map.get("tripper");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTripper((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tripCode")) {
      Object obj = map.get("tripCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTripCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bilTempleateName")) {
      Object obj = map.get("bilTempleateName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBilTempleateName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizNo")) {
      Object obj = map.get("bizNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBizNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyDate")) {
      Object obj = map.get("applyDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setApplyDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setApplyDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setApplyDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setApplyDate(null);
      }
    }
    if(map.containsKey("payDate")) {
      Object obj = map.get("payDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPayDate(null);
      }
    }
    if(map.containsKey("consumeReason")) {
      Object obj = map.get("consumeReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setConsumeReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCodeType")) {
      Object obj = map.get("chargeCodeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeCodeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeName")) {
      Object obj = map.get("chargeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeOwnerCode")) {
      Object obj = map.get("chargeOwnerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeOwnerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeOwnerName")) {
      Object obj = map.get("chargeOwnerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeOwnerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costAmount")) {
      Object obj = map.get("costAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("costType")) {
      Object obj = map.get("costType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCostType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costFullDetail")) {
      Object obj = map.get("costFullDetail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCostFullDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oneCostItem")) {
      Object obj = map.get("oneCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOneCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("twoCostItem")) {
      Object obj = map.get("twoCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTwoCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("threeCostItem")) {
      Object obj = map.get("threeCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setThreeCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fourCostItem")) {
      Object obj = map.get("fourCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFourCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fiveCostItem")) {
      Object obj = map.get("fiveCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFiveCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastCostItem")) {
      Object obj = map.get("lastCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLastCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refApplyCode")) {
      Object obj = map.get("refApplyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefApplyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refApplyName")) {
      Object obj = map.get("refApplyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payTypeName")) {
      Object obj = map.get("payTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shareRatio")) {
      Object obj = map.get("shareRatio");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setShareRatio((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setShareRatio(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setShareRatio(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setShareRatio(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setShareRatio(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("summaryDepartment")) {
      Object obj = map.get("summaryDepartment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSummaryDepartment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("joinSummary")) {
      Object obj = map.get("joinSummary");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJoinSummary((String)obj);
        }
      } else{
      }
    }
  }
}
