package com.xforceplus.ultraman.app.financialsettlement.metadata.validator;

import com.xforceplus.ultraman.app.financialsettlement.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.financialsettlement.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-12-11
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(Module.class)) {
            isValid = null != Module.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Module.class.getSimpleName());
            }
        }
        if(clazz.equals(Function.class)) {
            isValid = null != Function.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Function.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeDimension.class)) {
            isValid = null != ChargeDimension.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeDimension.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeType.class)) {
            isValid = null != ChargeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeType.class.getSimpleName());
            }
        }
        if(clazz.equals(Cycle.class)) {
            isValid = null != Cycle.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Cycle.class.getSimpleName());
            }
        }
        if(clazz.equals(Region.class)) {
            isValid = null != Region.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Region.class.getSimpleName());
            }
        }
        if(clazz.equals(CostType.class)) {
            isValid = null != CostType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CostType.class.getSimpleName());
            }
        }
        if(clazz.equals(Type.class)) {
            isValid = null != Type.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Type.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeRuleType.class)) {
            isValid = null != ChargeRuleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeRuleType.class.getSimpleName());
            }
        }
        if(clazz.equals(WhetherCalculate.class)) {
            isValid = null != WhetherCalculate.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WhetherCalculate.class.getSimpleName());
            }
        }
        if(clazz.equals(InputWay.class)) {
            isValid = null != InputWay.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InputWay.class.getSimpleName());
            }
        }
        if(clazz.equals(Profession.class)) {
            isValid = null != Profession.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Profession.class.getSimpleName());
            }
        }
        if(clazz.equals(Phase.class)) {
            isValid = null != Phase.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Phase.class.getSimpleName());
            }
        }
        if(clazz.equals(ActivityType.class)) {
            isValid = null != ActivityType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ActivityType.class.getSimpleName());
            }
        }
        if(clazz.equals(SolutionType.class)) {
            isValid = null != SolutionType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SolutionType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = null != DataSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(SubStat.class)) {
            isValid = null != SubStat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SubStat.class.getSimpleName());
            }
        }
        if(clazz.equals(AllocationStatus.class)) {
            isValid = null != AllocationStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AllocationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductPhase.class)) {
            isValid = null != ProductPhase.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProductPhase.class.getSimpleName());
            }
        }
        if(clazz.equals(CostBelong.class)) {
            isValid = null != CostBelong.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CostBelong.class.getSimpleName());
            }
        }
        if(clazz.equals(Property.class)) {
            isValid = null != Property.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Property.class.getSimpleName());
            }
        }
        if(clazz.equals(ContractAppoint.class)) {
            isValid = null != ContractAppoint.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ContractAppoint.class.getSimpleName());
            }
        }
        if(clazz.equals(TravelExpensePayer.class)) {
            isValid = null != TravelExpensePayer.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TravelExpensePayer.class.getSimpleName());
            }
        }
        if(clazz.equals(SignInvoiceType.class)) {
            isValid = null != SignInvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SignInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentNature.class)) {
            isValid = null != PaymentNature.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentNature.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductType.class)) {
            isValid = null != ProductType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProductType.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementCondition.class)) {
            isValid = null != SettlementCondition.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SettlementCondition.class.getSimpleName());
            }
        }
        if(clazz.equals(StartChargeCondition.class)) {
            isValid = null != StartChargeCondition.fromCode(value);
            if(!isValid) {
                unValidMsg(context, StartChargeCondition.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductFuctionType.class)) {
            isValid = null != ProductFuctionType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProductFuctionType.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductFuctionDesc.class)) {
            isValid = null != ProductFuctionDesc.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProductFuctionDesc.class.getSimpleName());
            }
        }
        if(clazz.equals(UseInvoiceType.class)) {
            isValid = null != UseInvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UseInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeType.class)) {
            isValid = null != IncomeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IncomeType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeType.class)) {
            isValid = null != ChargeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeType.class.getSimpleName());
            }
        }
        if(clazz.equals(WarrantyType.class)) {
            isValid = null != WarrantyType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WarrantyType.class.getSimpleName());
            }
        }
        if(clazz.equals(JobType.class)) {
            isValid = null != JobType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JobType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeVaildLogo.class)) {
            isValid = null != ChargeVaildLogo.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeVaildLogo.class.getSimpleName());
            }
        }
        if(clazz.equals(ReconcilationStatus.class)) {
            isValid = null != ReconcilationStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReconcilationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = null != BillStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReturnMoneyStatus.class)) {
            isValid = null != ReturnMoneyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReturnMoneyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Dimension.class)) {
            isValid = null != Dimension.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Dimension.class.getSimpleName());
            }
        }
        if(clazz.equals(WhtherOrNot.class)) {
            isValid = null != WhtherOrNot.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WhtherOrNot.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CurrentStatus.class)) {
            isValid = null != CurrentStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CurrentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SynchronizeType.class)) {
            isValid = null != SynchronizeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SynchronizeType.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = null != PaymentStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentRequirement.class)) {
            isValid = null != PaymentRequirement.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentRequirement.class.getSimpleName());
            }
        }
        if(clazz.equals(OLDNEWENUM.class)) {
            isValid = null != OLDNEWENUM.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OLDNEWENUM.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeTypeEnum.class)) {
            isValid = null != ChargeCodeTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeCodeTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeStatusEnum.class)) {
            isValid = null != ChargeCodeStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeCodeStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(MemberStatusEnum.class)) {
            isValid = null != MemberStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MemberStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(TakenStatus.class)) {
            isValid = null != TakenStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TakenStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ValidEnum.class)) {
            isValid = null != ValidEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ValidEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ActiveEnum.class)) {
            isValid = null != ActiveEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ActiveEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderType.class)) {
            isValid = null != OrderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxNoStatus.class)) {
            isValid = null != TaxNoStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxNoStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderStatus.class)) {
            isValid = null != OrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeStatus.class)) {
            isValid = null != IncomeStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IncomeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RecordType.class)) {
            isValid = null != RecordType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecordType.class.getSimpleName());
            }
        }
        if(clazz.equals(PmsMateDataEnum.class)) {
            isValid = null != PmsMateDataEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PmsMateDataEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ContractStatus.class)) {
            isValid = null != ContractStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ContractStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FinancifalBudgetType.class)) {
            isValid = null != FinancifalBudgetType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FinancifalBudgetType.class.getSimpleName());
            }
        }
        if(clazz.equals(PropertyEnum.class)) {
            isValid = null != PropertyEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PropertyEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ReconciliationStatusEnum.class)) {
            isValid = null != ReconciliationStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReconciliationStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeTypeEnum.class)) {
            isValid = null != ChargeTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentMethodEnum.class)) {
            isValid = null != PaymentMethodEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentMethodEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeBizDimensionEnum.class)) {
            isValid = null != ChargeBizDimensionEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeBizDimensionEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderInvoiceStatusEnum.class)) {
            isValid = null != OrderInvoiceStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderInvoiceStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(CompensateEnum.class)) {
            isValid = null != CompensateEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CompensateEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(MultiRelationDetailEnum.class)) {
            isValid = null != MultiRelationDetailEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MultiRelationDetailEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatusEnum.class)) {
            isValid = null != HandleStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(SupplementaryAgreementTypesEnum.class)) {
            isValid = null != SupplementaryAgreementTypesEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SupplementaryAgreementTypesEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PayType.class)) {
            isValid = null != PayType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PayType.class.getSimpleName());
            }
        }
        if(clazz.equals(ServiceOpenFlag.class)) {
            isValid = null != ServiceOpenFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ServiceOpenFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingType.class)) {
            isValid = null != BillingType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillingType.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderStatusEnum.class)) {
            isValid = null != OrderStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductIncomeType.class)) {
            isValid = null != ProductIncomeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProductIncomeType.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeConfirm.class)) {
            isValid = null != IncomeConfirm.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IncomeConfirm.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatusEnum.class)) {
            isValid = null != InvoiceStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceRedFlagEnum.class)) {
            isValid = null != InvoiceRedFlagEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceRedFlagEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColorEnum.class)) {
            isValid = null != InvoiceColorEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceColorEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTypeEnum.class)) {
            isValid = null != InvoiceTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PayStatus.class)) {
            isValid = null != PayStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentTypeEnum.class)) {
            isValid = null != PaymentTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderTypeEnum.class)) {
            isValid = null != OrderTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(SearchType.class)) {
            isValid = null != SearchType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SearchType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeType.class)) {
            isValid = null != ChargeCodeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeCodeType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeStatus.class)) {
            isValid = null != ChargeCodeStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeCodeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeArea.class)) {
            isValid = null != ChargeCodeArea.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeCodeArea.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeOrganization.class)) {
            isValid = null != ChargeCodeOrganization.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeCodeOrganization.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeRules.class)) {
            isValid = null != ChargeRules.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeRules.class.getSimpleName());
            }
        }
        if(clazz.equals(ProductStatus.class)) {
            isValid = null != ProductStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProductStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DeviceTypeEnum.class)) {
            isValid = null != DeviceTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DeviceTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCycleEnum.class)) {
            isValid = null != ChargeCycleEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeCycleEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingRuleEnum.class)) {
            isValid = null != BillingRuleEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillingRuleEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BindTypeEnum.class)) {
            isValid = null != BindTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BindTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(StandingBookStatusEnum.class)) {
            isValid = null != StandingBookStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, StandingBookStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(CostItem.class)) {
            isValid = null != CostItem.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CostItem.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeBudgetType.class)) {
            isValid = null != ChargeCodeBudgetType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeCodeBudgetType.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceptionStatus.class)) {
            isValid = null != ReceptionStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceptionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProjectStageStatus.class)) {
            isValid = null != ProjectStageStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProjectStageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessType.class)) {
            isValid = null != ProcessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProcessType.class.getSimpleName());
            }
        }
        if(clazz.equals(ModuleEnum.class)) {
            isValid = null != ModuleEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ModuleEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(DimensionEnum.class)) {
            isValid = null != DimensionEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DimensionEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BillTemplate.class)) {
            isValid = null != BillTemplate.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillTemplate.class.getSimpleName());
            }
        }
        if(clazz.equals(BillTemplateDetail.class)) {
            isValid = null != BillTemplateDetail.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillTemplateDetail.class.getSimpleName());
            }
        }
        if(clazz.equals(ProjectItemStatusEnum.class)) {
            isValid = null != ProjectItemStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProjectItemStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ProjectStageEnum.class)) {
            isValid = null != ProjectStageEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProjectStageEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(CapitalVerifyRuleType.class)) {
            isValid = null != CapitalVerifyRuleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CapitalVerifyRuleType.class.getSimpleName());
            }
        }
        if(clazz.equals(ContractTypes.class)) {
            isValid = null != ContractTypes.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ContractTypes.class.getSimpleName());
            }
        }
        if(clazz.equals(TravelExpensesBearer.class)) {
            isValid = null != TravelExpensesBearer.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TravelExpensesBearer.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallOrderStatus.class)) {
            isValid = null != SmallOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SmallOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallOrderWay.class)) {
            isValid = null != SmallOrderWay.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SmallOrderWay.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallOrderType.class)) {
            isValid = null != SmallOrderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SmallOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallContractStatus.class)) {
            isValid = null != SmallContractStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SmallContractStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallPaymentType.class)) {
            isValid = null != SmallPaymentType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SmallPaymentType.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallActivateStatus.class)) {
            isValid = null != SmallActivateStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SmallActivateStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallContractStatusMapping.class)) {
            isValid = null != SmallContractStatusMapping.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SmallContractStatusMapping.class.getSimpleName());
            }
        }
        if(clazz.equals(SourceMateDataEnum.class)) {
            isValid = null != SourceMateDataEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SourceMateDataEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(LegalEntityBudgetCenterType.class)) {
            isValid = null != LegalEntityBudgetCenterType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LegalEntityBudgetCenterType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeInvalidPushEnum.class)) {
            isValid = null != ChargeCodeInvalidPushEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeCodeInvalidPushEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(CdSignEnum.class)) {
            isValid = null != CdSignEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CdSignEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ForIndividEnum.class)) {
            isValid = null != ForIndividEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ForIndividEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(AdjustStatusEnum.class)) {
            isValid = null != AdjustStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AdjustStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(FkjBillTypeEnum.class)) {
            isValid = null != FkjBillTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FkjBillTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(FkjPayWayEnum.class)) {
            isValid = null != FkjPayWayEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FkjPayWayEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(FjkApproveStatusEnum.class)) {
            isValid = null != FjkApproveStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FjkApproveStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(FkjExpensesTypeEnum.class)) {
            isValid = null != FkjExpensesTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FkjExpensesTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(NotTakenChannelEnum.class)) {
            isValid = null != NotTakenChannelEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NotTakenChannelEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BillTypeSecondEnum.class)) {
            isValid = null != BillTypeSecondEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillTypeSecondEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(TenantTypeEnum.class)) {
            isValid = null != TenantTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TenantTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BsEmployTypeEnum.class)) {
            isValid = null != BsEmployTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BsEmployTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeCodeRelationEnum.class)) {
            isValid = null != ChargeCodeRelationEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeCodeRelationEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(SmallOrderserviceCloseType.class)) {
            isValid = null != SmallOrderserviceCloseType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SmallOrderserviceCloseType.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessDimension.class)) {
            isValid = null != BusinessDimension.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessDimension.class.getSimpleName());
            }
        }
        if(clazz.equals(YesNoEnum.class)) {
            isValid = null != YesNoEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, YesNoEnum.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
